#include <stdio.h>
#include <math.h>
#include <float.h>
#include <stdlib.h>
#include <time.h>
#include <qstring.h>
#include <qfile.h> 
#include <qtextstream.h>
#include <qstringlist.h>
#include <qregexp.h> 

#define MAXHIDDEN 50
#define MAXINPUT 30
#define NWEIGTHS MAXHIDDEN*MAXINPUT+2*MAXHIDDEN+1

// header for neural network

#ifndef __NN__
#define __NN__

class nn{
 public:
    nn(); // 
    ~nn();
    void set_n_hidden(unsigned int);
    void set_n_header(unsigned int);
    void set_separator(char);
    void set_y_output(int);
    int get_y_output();
    unsigned int get_n_lines();
    unsigned int get_n_elements();
    unsigned int get_n_inputs();
    double get_min(unsigned int);
    double get_max(unsigned int);
    double get_mean(unsigned int);
    double get_var(unsigned int);
    double get_corr(unsigned int);
    bool read_data(const QString&);
    bool data_avail();
    // part of training
    void set_max_error(double);
    void set_n_hidden(int);
    void set_n_inputs(int); 
    void set_coder(int,int);
    unsigned int get_coder(int);
    void set_shuffle(bool);
    void set_norm(bool);
    int train_lm();  
    int train_bp();
    int train_bpm();
    void reset();
    void mem_free();
    double step_lm(int); // number of training steps
    double step_bp(int);
    // access to values for ploting
    double get_output(unsigned int);
    double get_network(unsigned int);
    // access to test data
    unsigned int get_t_lines();
    double get_t_output(unsigned int);
    double get_t_network(unsigned int);
    double t_calc();
    // save and load network
    bool save_network(FILE *fp);
    bool load_network(FILE *fp);
    bool recalc_network();
    bool gen_test_data(QString&);
    bool set_default(unsigned int, double);
    bool set_input(unsigned int, unsigned int);
    // test 3d and 2d
    double get_3d(double,double);
    double get_2d(double);
    
 private:
    unsigned int n_hidden,n_inputs;
    unsigned int coder[30];
    double *min,*max,*mean,*var,*corr,**data;
    unsigned int n_lines, n_elements,n_header,t_lines;
    int y_output;
    QString separator;
    // part training
    unsigned int n_weights,n_outputs,steps;
    double *err,**o,**a,**net,**x,**d,*y;
    double w[NWEIGTHS],dw[NWEIGTHS],derr[NWEIGTHS];
    double oo,val,scalar,mut,factor,delta,alpha,lambda;
    double err_,err__,thresh;
    bool data_available,is_trained,is_shuffle,is_norm;
    // part testdata
    double **tdata, *ot, *yt, **xt;
    // part 3d-view
    double defaults[MAXINPUT];
    unsigned int inputs[MAXINPUT];
    int *shuffle_f;
};

#endif
